//
//  YHHKMemberModel.swift
//  galaxy
//
//  Created by edy on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

// [YHHKMemberModel] 数组实现神拷贝
extension Array where Element == YHHKMemberModel {
    
    func deepCopy() -> [YHHKMemberModel] {
        var results: [YHHKMemberModel] = []
        for item in self {
            let newItem = item.copy()
            results.append(newItem as! YHHKMemberModel)
        }
        return results
    }
}

class YHHKMemberModel: SmartCodable, NSCopying {
    
    var id: Int = 0
    var name: String = ""
    var type: String = ""
    var fileNum: String = ""
    var birthday: String = ""
    var isCheck: Int = 0
    var url: String = ""
    var approvalDate: String = ""
    
    // 自定义
    var isSelected: Bool = false //本地使用

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case type = "type"
        case fileNum = "file_num"
        case birthday = "birthday"
        case isCheck = "is_check"
        case url = "url"
        case approvalDate = "approval_date"
    }
    
    required init() {
        
    }

    init(id: Int, name: String, type: String, fileNum: String, birthday: String, isCheck: Int, url: String, approvalDate: String, isSelected: Bool) {
        self.id = id
        self.name = name
        self.type = type
        self.fileNum = fileNum
        self.birthday = birthday
        self.isCheck = isCheck
        self.url = url
        self.approvalDate = approvalDate
        self.isSelected = isSelected
    }
    
    func copy(with zone: NSZone? = nil) -> Any {
        
        return YHHKMemberModel(id: self.id, name: self.name, type: self.type, fileNum: self.fileNum, birthday: self.birthday, isCheck: self.isCheck, url: self.url, approvalDate: self.approvalDate, isSelected: isSelected)
    }
    
    func isAtLeast11Years() -> Bool {
        return self._isAtLeast11Years(from: self.birthday)
    }
    
    func getAgeAndMonth() -> String {
        return self._getAgeAndMonths(from: self.birthday)
    }
    
    private func _isAtLeast11Years(from birthDateString: String) -> Bool {
        // 1. 将生日字符串转换为 Date 对象
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        guard let birthDate = dateFormatter.date(from: birthDateString) else {
            return false
        }

        // 2. 计算当前日期和生日之间的年龄差
        let currentDate = Date()
        let calendar = Calendar.current
        let ageComponents = calendar.dateComponents([.year], from: birthDate, to: currentDate)
        guard let age = ageComponents.year else {
            return false
        }

        // 3. 判断年龄是否大于或等于 11 岁
        return age >= 11
    }
    
    
    // 返回X岁Y个月
    func _getAgeAndMonths(from birthDateString: String) -> String {
        // 1. 将生日字符串转换为 Date 对象
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        guard let birthDate = dateFormatter.date(from: birthDateString) else {
            return "0岁"
        }

        // 2. 计算当前日期和生日之间的年龄差和月龄差
        let currentDate = Date()
        let calendar = Calendar.current
        let dateComponents = calendar.dateComponents([.year, .month], from: birthDate, to: currentDate)
        guard let years = dateComponents.year, let months = dateComponents.month else {
            return "0岁"
        }

        var text = ""
        if years > 0 {
            text += "\(years)岁"
        }
        if months > 0 {
            text += "\(months)个月"
        }
        return text
    }

}


